/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.namespace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.io.namespace.AlternativeMapping;
import org.eurocarbdb.MolecularFramework.io.namespace.GlycoVisitorLinkageTypeNormalisation;
import org.eurocarbdb.MolecularFramework.io.namespace.GlycoVisitorToGlycoCT;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraphAlternative;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbMonosaccharide;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConversion;
import org.eurocarbdb.resourcesdb.io.MonosaccharideExchangeObject;
import org.eurocarbdb.resourcesdb.io.SubstituentExchangeObject;

public class GlycoVisitorToGlycoCTextendMSDB
extends GlycoVisitorToGlycoCT {
    public GlycoVisitorToGlycoCTextendMSDB(MonosaccharideConversion translator) {
        super(translator);
    }

    public GlycoVisitorToGlycoCTextendMSDB(MonosaccharideConversion translator, GlycanNamescheme schema) {
        super(translator, schema);
    }

    @Override
    public void visit(SugarUnitRepeat a_objRepeate) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            GlycoVisitorToGlycoCTextendMSDB t_objVisitor = new GlycoVisitorToGlycoCTextendMSDB(this.m_objConverter, this.m_strSchema);
            t_objVisitor.setUseStrict(this.m_bStrict);
            SugarUnitRepeat t_objUnit = t_objVisitor.start(a_objRepeate);
            this.m_hashResidues.put(a_objRepeate, t_objUnit);
            try {
                this.m_objUnit.addNode(t_objUnit);
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException("Could not create Repeat : ", e);
            }
            this.copyParentLinkage(a_objRepeate.getParentEdge(), t_objUnit);
        }
    }

    @Override
    public void visit(UnvalidatedGlycoNode a_objResidue) throws GlycoVisitorException {
        block45: {
            if (this.m_objTraverser.getState() == 0) {
                try {
                    MonosaccharideExchangeObject t_objData = this.m_objConverter.convertMonosaccharide(a_objResidue.getName(), this.m_strSchema, GlycanNamescheme.GLYCOCT);
                    EcdbMonosaccharide t_objMSdbMS = t_objData.getBasetype();
                    Monosaccharide t_objMS = this.createMS(t_objMSdbMS);
                    this.m_hashResidues.put(a_objResidue, t_objMS);
                    try {
                        this.m_objUnit.addNode(t_objMS);
                    }
                    catch (GlycoconjugateException e) {
                        throw new GlycoVisitorException("Could not create normalized monosaccharide : " + e.getMessage(), e);
                    }
                    for (SubstituentExchangeObject t_objSubstMSdb : t_objData.getSubstituents()) {
                        Substituent t_objSubst = new Substituent(SubstituentType.forName(t_objSubstMSdb.getName()));
                        GlycoEdge t_objEdge = new GlycoEdge();
                        Linkage t_objLinkage = new Linkage();
                        t_objLinkage.setParentLinkageType(LinkageType.forName(t_objSubstMSdb.getLinkagetype1().getType()));
                        t_objLinkage.setChildLinkageType(LinkageType.NONMONOSACCHARID);
                        ArrayList<Integer> t_aPositions = t_objSubstMSdb.getPosition1();
                        for (Integer t_iPosition : t_aPositions) {
                            if (t_iPosition == 0) {
                                if (t_aPositions.size() != 1) {
                                    throw new GlycoVisitorException("Linkage for substituent " + t_objSubst.getSubstituentType().getName() + " can only be unknown or a destinct linkage, not both.");
                                }
                                t_objLinkage.addParentLinkage(-1);
                                continue;
                            }
                            t_objLinkage.addParentLinkage(t_iPosition);
                        }
                        t_aPositions = t_objSubstMSdb.getSubstituentPosition1();
                        for (Integer t_iPosition : t_aPositions) {
                            if (t_iPosition == 0) {
                                if (t_aPositions.size() != 1) {
                                    throw new GlycoVisitorException("Linkage at substituent " + t_objSubst.getSubstituentType().getName() + " can only be unknown or a destinct linkage, not both.");
                                }
                                t_objLinkage.addChildLinkage(-1);
                                continue;
                            }
                            t_objLinkage.addChildLinkage(t_iPosition);
                        }
                        t_objEdge.addGlycosidicLinkage(t_objLinkage);
                        t_aPositions = t_objSubstMSdb.getPosition2();
                        if (t_aPositions.size() > 0) {
                            t_objLinkage = new Linkage();
                            t_objLinkage.setParentLinkageType(LinkageType.forName(t_objSubstMSdb.getLinkagetype2().getType()));
                            t_objLinkage.setChildLinkageType(LinkageType.NONMONOSACCHARID);
                            t_aPositions = t_objSubstMSdb.getPosition2();
                            for (Integer t_iPosition : t_aPositions) {
                                if (t_iPosition == 0) {
                                    if (t_aPositions.size() != 1) {
                                        throw new GlycoVisitorException("Linkage for substituent " + t_objSubst.getSubstituentType().getName() + " can only be unknown or a destinct linkage, not both.");
                                    }
                                    t_objLinkage.addParentLinkage(-1);
                                    continue;
                                }
                                t_objLinkage.addParentLinkage(t_iPosition);
                            }
                            t_aPositions = t_objSubstMSdb.getSubstituentPosition2();
                            for (Integer t_iPosition : t_aPositions) {
                                if (t_iPosition == 0) {
                                    if (t_aPositions.size() != 1) {
                                        throw new GlycoVisitorException("Linkage at substituent " + t_objSubst.getSubstituentType().getName() + " can only be unknown or a destinct linkage, not both.");
                                    }
                                    t_objLinkage.addChildLinkage(-1);
                                    continue;
                                }
                                t_objLinkage.addChildLinkage(t_iPosition);
                            }
                            t_objEdge.addGlycosidicLinkage(t_objLinkage);
                        }
                        this.m_objUnit.addNode(t_objSubst);
                        this.m_objUnit.addEdge(t_objMS, t_objSubst, t_objEdge);
                    }
                    GlycoEdge t_objPEdge = a_objResidue.getParentEdge();
                    if (t_objPEdge != null && (t_objPEdge = a_objResidue.getParentEdge().copy()) != null) {
                        GlycoNode t_objParent = (GlycoNode)this.m_hashResidues.get(a_objResidue.getParentNode());
                        if (t_objParent == null) {
                            throw new GlycoVisitorException("Critical error: missing parent residue for subtituent : " + t_objMS.getGlycoCTName());
                        }
                        this.m_objUnit.addEdge(t_objParent, t_objMS, t_objPEdge);
                    }
                }
                catch (ResourcesDbException e) {
                    try {
                        GlycoEdge t_objPEdge2;
                        SubstituentExchangeObject t_objSubstExchange = new SubstituentExchangeObject(this.m_strSchema);
                        t_objSubstExchange.setName(a_objResidue.getName());
                        t_objSubstExchange = this.m_objConverter.convertSubstituent(t_objSubstExchange, this.m_strSchema, GlycanNamescheme.GLYCOCT);
                        Substituent t_objSubst = new Substituent(SubstituentType.forName(t_objSubstExchange.getName()));
                        this.m_hashResidues.put(a_objResidue, t_objSubst);
                        try {
                            this.m_objUnit.addNode(t_objSubst);
                        }
                        catch (GlycoconjugateException e2) {
                            throw new GlycoVisitorException("Could not create Substituten : " + t_objSubst.getSubstituentType().getName(), e2);
                        }
                        int t_iCounter = 1;
                        if (this.m_objInternalOriginalEdge != null && this.m_objInternalOriginalEdge.getChild() == a_objResidue) {
                            for (Linkage t_objLinkage : this.m_objInternal.getGlycosidicLinkages()) {
                                t_objLinkage.setChildLinkageType(LinkageType.NONMONOSACCHARID);
                                t_objLinkage.setParentLinkageType(this.getLinkageType(t_iCounter++, t_objSubstExchange));
                            }
                        }
                        if ((t_objPEdge2 = a_objResidue.getParentEdge()) != null && (t_objPEdge2 = a_objResidue.getParentEdge().copy()) != null) {
                            for (Linkage t_objLinkage : t_objPEdge2.getGlycosidicLinkages()) {
                                t_objLinkage.setChildLinkageType(LinkageType.NONMONOSACCHARID);
                                t_objLinkage.setParentLinkageType(this.getLinkageType(t_iCounter++, t_objSubstExchange));
                            }
                            GlycoNode t_objParent = (GlycoNode)this.m_hashResidues.get(a_objResidue.getParentNode());
                            if (t_objParent == null) {
                                throw new GlycoVisitorException("Critical error: missing parent residue for subtituent : " + t_objSubst.getSubstituentType().getName());
                            }
                            this.m_objUnit.addEdge(t_objParent, t_objSubst, t_objPEdge2);
                        }
                        for (GlycoEdge t_objPEdge2 : a_objResidue.getChildEdges()) {
                            for (Linkage t_objLinkage : t_objPEdge2.getGlycosidicLinkages()) {
                                t_objLinkage.setParentLinkageType(LinkageType.NONMONOSACCHARID);
                                t_objLinkage.setChildLinkageType(this.getLinkageType(t_iCounter++, t_objSubstExchange));
                            }
                        }
                        if (this.m_objInternalOriginalEdge != null && this.m_objInternalOriginalEdge.getParent() == a_objResidue) {
                            for (Linkage t_objLinkage : this.m_objInternal.getGlycosidicLinkages()) {
                                t_objLinkage.setParentLinkageType(LinkageType.NONMONOSACCHARID);
                                if (t_objLinkage.getChildLinkageType() == LinkageType.NONMONOSACCHARID) continue;
                                t_objLinkage.setChildLinkageType(this.getLinkageType(t_iCounter++, t_objSubstExchange));
                            }
                        }
                    }
                    catch (ResourcesDbException e1) {
                        try {
                            if (this.m_bStrict) {
                                try {
                                    String t_strName = this.m_objConverter.convertAglycon(a_objResidue.getName(), this.m_strSchema, GlycanNamescheme.GLYCOCT);
                                    NonMonosaccharide t_objNonMS = new NonMonosaccharide(t_strName);
                                    this.m_hashResidues.put(a_objResidue, t_objNonMS);
                                    this.m_objUnit.addNode(t_objNonMS);
                                    GlycoEdge t_objPEdge = a_objResidue.getParentEdge();
                                    if (t_objPEdge != null && (t_objPEdge = a_objResidue.getParentEdge().copy()) != null) {
                                        GlycoNode t_objParent = (GlycoNode)this.m_hashResidues.get(a_objResidue.getParentNode());
                                        if (t_objParent == null) {
                                            throw new GlycoVisitorException("Critical error: missing parent residue for subtituent : " + t_objNonMS.getName());
                                        }
                                        this.m_objUnit.addEdge(t_objParent, t_objNonMS, t_objPEdge);
                                    }
                                    break block45;
                                }
                                catch (ResourcesDbException e2) {
                                    throw new GlycoVisitorException("Unknown residue (aglyca?): " + a_objResidue.getName());
                                }
                            }
                            String t_strName = a_objResidue.getName();
                            NonMonosaccharide t_objNonMS = new NonMonosaccharide(t_strName);
                            this.m_hashResidues.put(a_objResidue, t_objNonMS);
                            this.m_objUnit.addNode(t_objNonMS);
                            GlycoEdge t_objPEdge = a_objResidue.getParentEdge();
                            if (t_objPEdge != null && (t_objPEdge = a_objResidue.getParentEdge().copy()) != null) {
                                GlycoNode t_objParent = (GlycoNode)this.m_hashResidues.get(a_objResidue.getParentNode());
                                if (t_objParent == null) {
                                    throw new GlycoVisitorException("Critical error: missing parent residue for historical data : " + t_objNonMS.getName());
                                }
                                this.m_objUnit.addEdge(t_objParent, t_objNonMS, t_objPEdge);
                            }
                        }
                        catch (GlycoconjugateException ex) {
                            throw new GlycoVisitorException(ex.getMessage(), ex);
                        }
                    }
                    catch (GlycoconjugateException ex) {
                        throw new GlycoVisitorException(ex.getMessage(), ex);
                    }
                }
                catch (GlycoconjugateException e) {
                    throw new GlycoVisitorException(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    protected LinkageType getLinkageType(int a_iCounter, SubstituentExchangeObject a_objSubstExchange) throws GlycoconjugateException {
        if (a_iCounter == 1) {
            org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType t_objType = a_objSubstExchange.getLinkagetype1();
            if (t_objType != null) {
                return LinkageType.forName(t_objType.getType());
            }
        } else if (a_iCounter == 2) {
            org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType t_objType = a_objSubstExchange.getLinkagetype2();
            if (t_objType != null) {
                return LinkageType.forName(t_objType.getType());
            }
        } else {
            org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType t_objType = a_objSubstExchange.getLinkagetype3();
            if (t_objType != null) {
                return LinkageType.forName(t_objType.getType());
            }
        }
        if (a_iCounter == 2) {
            if (a_objSubstExchange.getName().equals(SubstituentType.ETHANOLAMINE.getName())) {
                return LinkageType.H_AT_OH;
            }
            if (a_objSubstExchange.getName().equals(SubstituentType.AMINO.getName())) {
                return LinkageType.DEOXY;
            }
            if (a_objSubstExchange.getName().equals(SubstituentType.PHOSPHATE.getName())) {
                return LinkageType.H_AT_OH;
            }
            if (a_objSubstExchange.getName().equals(SubstituentType.SULFATE.getName())) {
                return LinkageType.H_AT_OH;
            }
            if (a_objSubstExchange.getName().equals(SubstituentType.R_PYRUVATE.getName())) {
                return LinkageType.DEOXY;
            }
            if (a_objSubstExchange.getName().equals(SubstituentType.S_PYRUVATE.getName())) {
                return LinkageType.DEOXY;
            }
        }
        throw new GlycoconjugateException(String.format("SubstituentExchangeObject does not contain information for linkage %d at substituten %s.", a_iCounter, a_objSubstExchange.getName()));
    }

    @Override
    public void visit(SugarUnitAlternative a_objAlternative) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 0) {
            SugarUnitAlternative t_objCopy = new SugarUnitAlternative();
            this.copyParentLinkage(a_objAlternative.getParentEdge(), t_objCopy);
            for (GlycoGraphAlternative t_objGraph : a_objAlternative.getAlternatives()) {
                GlycoVisitorToGlycoCTextendMSDB t_objVisitor = new GlycoVisitorToGlycoCTextendMSDB(this.m_objConverter, this.m_strSchema);
                t_objVisitor.setUseStrict(this.m_bStrict);
                GlycoGraphAlternative t_objGraphCopy = t_objVisitor.start(t_objGraph, t_objCopy);
                this.m_aAlternative.add(new AlternativeMapping(a_objAlternative, t_objGraph, t_objCopy, t_objGraphCopy, t_objVisitor.getResidueMapping()));
            }
            this.m_hashResidues.put(a_objAlternative, t_objCopy);
            try {
                this.m_objUnit.addNode(t_objCopy);
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException("Could not create alternative : ", e);
            }
        }
    }

    @Override
    protected SugarUnitRepeat start(SugarUnitRepeat a_objSugar) throws GlycoVisitorException {
        this.clear();
        if (this.m_objConverter != null) {
            this.m_objInternalOriginalEdge = a_objSugar.getRepeatLinkage();
            this.m_objRepeat = new SugarUnitRepeat();
            this.m_objUnit = this.m_objRepeat;
            this.m_objRepeat.setMinRepeatCount(a_objSugar.getMinRepeatCount());
            this.m_objRepeat.setMaxRepeatCount(a_objSugar.getMaxRepeatCount());
            try {
                GlycoEdge t_objOringal = a_objSugar.getRepeatLinkage();
                this.m_objInternal = t_objOringal.copy();
                this.m_objTraverser = this.getTraverser(this);
                this.m_objTraverser.traverseGraph(a_objSugar);
                this.m_objRepeat.setRepeatLinkage(this.m_objInternal, (GlycoNode)this.m_hashResidues.get(t_objOringal.getParent()), (GlycoNode)this.m_hashResidues.get(t_objOringal.getChild()));
                Iterator<UnderdeterminedSubTree> t_iterSpezialTrees = a_objSugar.getUndeterminedSubTrees().iterator();
                while (t_iterSpezialTrees.hasNext()) {
                    GlycoVisitorToGlycoCTextendMSDB t_objVisitor = new GlycoVisitorToGlycoCTextendMSDB(this.m_objConverter, this.m_strSchema);
                    t_objVisitor.setUseStrict(this.m_bStrict);
                    t_objVisitor.setMonosaccharideConversion(this.m_objConverter);
                    UnderdeterminedSubTree t_objSubtreeOriginal = t_iterSpezialTrees.next();
                    UnderdeterminedSubTree t_objSubtree = t_objVisitor.start(t_objSubtreeOriginal);
                    this.m_objRepeat.addUndeterminedSubTree(t_objSubtree);
                    t_objSubtree.setConnection(t_objSubtreeOriginal.getConnection().copy());
                    t_objSubtree.setProbability(t_objSubtreeOriginal.getProbabilityLower(), t_objSubtreeOriginal.getProbabilityUpper());
                    Iterator<GlycoNode> t_iterParents = t_objSubtreeOriginal.getParents().iterator();
                    while (t_iterParents.hasNext()) {
                        GlycoNode t_objParent = (GlycoNode)this.m_hashResidues.get(t_iterParents.next());
                        if (t_objParent == null) {
                            throw new GlycoVisitorException("Crictial error by adding null as a parent of a UnderdeterminedSubTree.");
                        }
                        this.m_objRepeat.addUndeterminedSubTreeParent(t_objSubtree, t_objParent);
                    }
                }
                for (AlternativeMapping t_objAlternative : this.m_aAlternative) {
                    HashMap<GlycoNode, GlycoNode> t_hMapNew = new HashMap<GlycoNode, GlycoNode>();
                    HashMap<GlycoNode, GlycoNode> t_hMapOld = t_objAlternative.getGraphOriginal().getLeadOutNodeToNode();
                    HashMap<GlycoNode, GlycoNode> t_hIntern = t_objAlternative.getMapping();
                    for (GlycoNode t_objOuterOld : t_hMapOld.keySet()) {
                        GlycoNode t_objOuterNew = (GlycoNode)this.m_hashResidues.get(t_objOuterOld);
                        if (t_objOuterNew == null) {
                            throw new GlycoconjugateException("Error child attache position of alternative graph was not translated.");
                        }
                        GlycoNode t_objInnerOld = t_hMapOld.get(t_objOuterOld);
                        GlycoNode t_objInnerNew = t_hIntern.get(t_objInnerOld);
                        if (t_objInnerNew == null) {
                            throw new GlycoconjugateException("Error child inner attache position of alternative graph was not translated.");
                        }
                        t_hMapNew.put(t_objOuterNew, t_objInnerNew);
                    }
                    t_objAlternative.getCopy().setLeadOutNodeToNode(t_hMapNew, t_objAlternative.getGraphCopy());
                }
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
        }
        return this.m_objRepeat;
    }

    @Override
    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        this.clear();
        if (this.m_objConverter != null) {
            this.m_objNewSugar = new Sugar();
            this.m_objUnit = this.m_objNewSugar;
            this.m_objTraverser = this.getTraverser(this);
            this.m_objTraverser.traverseGraph(a_objSugar);
            try {
                Iterator<UnderdeterminedSubTree> t_iterSpezialTrees = a_objSugar.getUndeterminedSubTrees().iterator();
                while (t_iterSpezialTrees.hasNext()) {
                    GlycoVisitorToGlycoCTextendMSDB t_objVisitor = new GlycoVisitorToGlycoCTextendMSDB(this.m_objConverter, this.m_strSchema);
                    t_objVisitor.setUseStrict(this.m_bStrict);
                    t_objVisitor.setMonosaccharideConversion(this.m_objConverter);
                    UnderdeterminedSubTree t_objSubtreeOriginal = t_iterSpezialTrees.next();
                    UnderdeterminedSubTree t_objSubtree = t_objVisitor.start(t_objSubtreeOriginal);
                    this.m_objNewSugar.addUndeterminedSubTree(t_objSubtree);
                    if (t_objSubtreeOriginal.getConnection() != null) {
                        t_objSubtree.setConnection(t_objSubtreeOriginal.getConnection().copy());
                    }
                    t_objSubtree.setProbability(t_objSubtreeOriginal.getProbabilityLower(), t_objSubtreeOriginal.getProbabilityUpper());
                    Iterator<GlycoNode> t_iterParents = t_objSubtreeOriginal.getParents().iterator();
                    while (t_iterParents.hasNext()) {
                        GlycoNode t_objParent = (GlycoNode)this.m_hashResidues.get(t_iterParents.next());
                        if (t_objParent == null) {
                            throw new GlycoVisitorException("Crictial error by adding null as a parent of a UnderdeterminedSubTree.");
                        }
                        this.m_objNewSugar.addUndeterminedSubTreeParent(t_objSubtree, t_objParent);
                    }
                }
                for (AlternativeMapping t_objAlternative : this.m_aAlternative) {
                    HashMap<GlycoNode, GlycoNode> t_hMapNew = new HashMap<GlycoNode, GlycoNode>();
                    HashMap<GlycoNode, GlycoNode> t_hMapOld = t_objAlternative.getGraphOriginal().getLeadOutNodeToNode();
                    HashMap<GlycoNode, GlycoNode> t_hIntern = t_objAlternative.getMapping();
                    for (GlycoNode t_objOuterOld : t_hMapOld.keySet()) {
                        GlycoNode t_objOuterNew = (GlycoNode)this.m_hashResidues.get(t_objOuterOld);
                        if (t_objOuterNew == null) {
                            throw new GlycoconjugateException("Error child attache position of alternative graph was not translated.");
                        }
                        GlycoNode t_objInnerOld = t_hMapOld.get(t_objOuterOld);
                        GlycoNode t_objInnerNew = t_hIntern.get(t_objInnerOld);
                        if (t_objInnerNew == null) {
                            throw new GlycoconjugateException("Error child inner attache position of alternative graph was not translated.");
                        }
                        t_hMapNew.put(t_objOuterNew, t_objInnerNew);
                    }
                    t_objAlternative.getCopy().setLeadOutNodeToNode(t_hMapNew, t_objAlternative.getGraphCopy());
                }
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
            GlycoVisitorLinkageTypeNormalisation t_objVisitor = new GlycoVisitorLinkageTypeNormalisation();
            t_objVisitor.start(this.m_objNewSugar);
        }
        if (this.m_bFusion) {
            this.m_visFuse.start(this.m_objNewSugar);
        }
        if (this.m_bSubstPosition) {
            this.m_visSubstPostion.start(this.m_objNewSugar);
        }
    }
}

