/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.namespace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.Superclass;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserTreeSingleWood;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;

public class GlycoVisitorFuseSubstituent
implements GlycoVisitor {
    private ArrayList<Substituent> m_aSubstituent = new ArrayList();
    private ArrayList<Monosaccharide> m_aMonosaccharides = new ArrayList();
    private SugarUnitRepeat m_objRepeat = null;
    private boolean m_bSzenarioOne = true;
    private boolean m_bSzenarioTwo = true;
    private boolean m_bSzenarioThree = true;
    private boolean m_bSzenarioFour = true;
    private boolean m_bSzenarioFive = false;

    public void setSzenarioOne(boolean a_b) {
        this.m_bSzenarioOne = a_b;
    }

    public void setSzenarioTwo(boolean a_b) {
        this.m_bSzenarioTwo = a_b;
    }

    public void setSzenarioThree(boolean a_b) {
        this.m_bSzenarioThree = a_b;
    }

    public void setSzenarioFour(boolean a_b) {
        this.m_bSzenarioFour = a_b;
    }

    public void setSzenarioFive(boolean a_b) {
        this.m_bSzenarioFive = a_b;
    }

    @Override
    public void visit(Monosaccharide a_objMonosaccharide) throws GlycoVisitorException {
        this.m_aMonosaccharides.add(a_objMonosaccharide);
    }

    @Override
    public void visit(NonMonosaccharide a_objResidue) throws GlycoVisitorException {
    }

    @Override
    public void visit(SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        GlycoVisitorFuseSubstituent t_objVisitor = new GlycoVisitorFuseSubstituent();
        t_objVisitor.setSzenarioOne(this.m_bSzenarioOne);
        t_objVisitor.setSzenarioThree(this.m_bSzenarioThree);
        t_objVisitor.setSzenarioTwo(this.m_bSzenarioTwo);
        t_objVisitor.setSzenarioFour(this.m_bSzenarioFour);
        t_objVisitor.setSzenarioFive(this.m_bSzenarioFive);
        t_objVisitor.start(a_objRepeat);
    }

    public void start(SugarUnitRepeat a_objSugar) throws GlycoVisitorException {
        this.clear();
        this.m_objRepeat = a_objSugar;
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph(a_objSugar);
        try {
            this.fuse(a_objSugar);
        }
        catch (GlycoconjugateException e) {
            throw new GlycoVisitorException(e.getMessage(), e);
        }
        Iterator<UnderdeterminedSubTree> t_iterUnder = a_objSugar.getUndeterminedSubTrees().iterator();
        while (t_iterUnder.hasNext()) {
            GlycoVisitorFuseSubstituent t_objNN = new GlycoVisitorFuseSubstituent();
            t_objNN.setSzenarioOne(this.m_bSzenarioOne);
            t_objNN.setSzenarioThree(this.m_bSzenarioThree);
            t_objNN.setSzenarioTwo(this.m_bSzenarioTwo);
            t_objNN.setSzenarioFour(this.m_bSzenarioFour);
            t_objNN.setSzenarioFive(this.m_bSzenarioFive);
            t_objNN.start(t_iterUnder.next());
        }
    }

    public void start(UnderdeterminedSubTree a_objSugar) throws GlycoVisitorException {
        this.clear();
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph(a_objSugar);
        try {
            this.fuse(a_objSugar);
        }
        catch (GlycoconjugateException e) {
            throw new GlycoVisitorException(e.getMessage(), e);
        }
    }

    @Override
    public void visit(Substituent a_objSubstituent) throws GlycoVisitorException {
        this.m_aSubstituent.add(a_objSubstituent);
    }

    @Override
    public void visit(SugarUnitCyclic a_objCyclic) throws GlycoVisitorException {
    }

    @Override
    public void visit(SugarUnitAlternative a_objAlternative) throws GlycoVisitorException {
        throw new GlycoVisitorException("SugarUnitAlternative is not supported.");
    }

    @Override
    public void visit(UnvalidatedGlycoNode a_objUnvalidated) throws GlycoVisitorException {
    }

    @Override
    public void visit(GlycoEdge a_objLinkage) throws GlycoVisitorException {
    }

    @Override
    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        this.clear();
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph(a_objSugar);
        try {
            this.fuse(a_objSugar);
        }
        catch (GlycoconjugateException e) {
            throw new GlycoVisitorException(e.getMessage(), e);
        }
        Iterator<UnderdeterminedSubTree> t_iterUnder = a_objSugar.getUndeterminedSubTrees().iterator();
        while (t_iterUnder.hasNext()) {
            GlycoVisitorFuseSubstituent t_objNN = new GlycoVisitorFuseSubstituent();
            t_objNN.setSzenarioOne(this.m_bSzenarioOne);
            t_objNN.setSzenarioThree(this.m_bSzenarioThree);
            t_objNN.setSzenarioTwo(this.m_bSzenarioTwo);
            t_objNN.setSzenarioFour(this.m_bSzenarioFour);
            t_objNN.setSzenarioFive(this.m_bSzenarioFive);
            t_objNN.start(t_iterUnder.next());
        }
    }

    @Override
    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserTreeSingleWood(a_objVisitor);
    }

    @Override
    public void clear() {
        this.m_objRepeat = null;
        this.m_aMonosaccharides.clear();
        this.m_aSubstituent.clear();
    }

    private void fuse(GlycoGraph a_objGraph) throws GlycoconjugateException, GlycoVisitorException {
        if (this.m_bSzenarioOne) {
            this.solveSzenarioOne(a_objGraph);
        }
        if (this.m_bSzenarioTwo) {
            this.solveSzenarioTwo(a_objGraph);
        }
        if (this.m_bSzenarioThree) {
            this.solveSzenarioThree(a_objGraph);
        }
        if (this.m_bSzenarioFour) {
            this.solveSzenarioFour(a_objGraph);
        }
        if (this.m_bSzenarioFive) {
            this.solveSzenarioFive(a_objGraph);
        }
    }

    private void solveSzenarioOne(GlycoGraph a_objSugar) throws GlycoVisitorException, GlycoconjugateException {
        GlycoVisitorNodeType t_objNodeType = new GlycoVisitorNodeType();
        ArrayList<Substituent> t_aDeletedSubst = new ArrayList<Substituent>();
        for (Monosaccharide t_objMS : this.m_aMonosaccharides) {
            ArrayList<GlycoEdge> t_aLinkages = t_objMS.getChildEdges();
            if (t_aLinkages.size() <= 1) continue;
            ArrayList<GlycoEdge> t_aEdgeClone = new ArrayList<GlycoEdge>();
            for (GlycoEdge t_objLinkages : t_aLinkages) {
                t_aEdgeClone.add(t_objLinkages);
            }
            for (GlycoEdge t_objEdgeAmino : t_aEdgeClone) {
                Substituent t_objAmino;
                GlycoNode t_objResidue = t_objEdgeAmino.getChild();
                if (!t_objNodeType.isSubstituent(t_objResidue) || (t_objAmino = (Substituent)t_objResidue).getSubstituentType() != SubstituentType.AMINO || t_objEdgeAmino.getGlycosidicLinkages().size() != 1 || t_aDeletedSubst.contains(t_objAmino)) continue;
                Linkage t_objLinkageAmino = t_objEdgeAmino.getGlycosidicLinkages().get(0);
                for (GlycoEdge t_objEdgeAmino2 : t_aEdgeClone) {
                    Substituent t_objAminoTwo;
                    t_objResidue = t_objEdgeAmino2.getChild();
                    if (!t_objNodeType.isSubstituent(t_objResidue) || t_aDeletedSubst.contains(t_objAminoTwo = (Substituent)t_objResidue) || t_objEdgeAmino2.getGlycosidicLinkages().size() != 1) continue;
                    Linkage t_objLinkageSub = t_objEdgeAmino2.getGlycosidicLinkages().get(0);
                    if (t_objAminoTwo.getSubstituentType() != SubstituentType.AMINO || t_objAmino == t_objAminoTwo || !this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageAmino.getParentLinkages())) continue;
                    if (t_objAmino.getChildEdges().size() > 0 && t_objAminoTwo.getChildEdges().size() > 0) {
                        throw new GlycoVisitorException("Error in Amino-Child linkage.");
                    }
                    if (t_objAmino.getChildEdges().size() > 0) {
                        t_objLinkageAmino.setParentLinkageType(LinkageType.DEOXY);
                        a_objSugar.removeNode(t_objAminoTwo);
                        this.m_aSubstituent.remove(t_objAminoTwo);
                        t_aDeletedSubst.add(t_objAminoTwo);
                        continue;
                    }
                    t_objLinkageSub.setParentLinkageType(LinkageType.DEOXY);
                    a_objSugar.removeNode(t_objAmino);
                    this.m_aSubstituent.remove(t_objAmino);
                    t_aDeletedSubst.add(t_objAmino);
                }
            }
        }
    }

    private void solveSzenarioTwo(GlycoGraph a_objSugar) throws GlycoVisitorException, GlycoconjugateException {
        GlycoVisitorNodeType t_objNodeType = new GlycoVisitorNodeType();
        for (Monosaccharide t_objMS : this.m_aMonosaccharides) {
            ArrayList<GlycoEdge> t_aEdges = t_objMS.getChildEdges();
            if (t_aEdges.size() <= 1) continue;
            ArrayList<GlycoEdge> t_aEdgeClone = new ArrayList<GlycoEdge>();
            for (GlycoEdge t_objLinkages : t_aEdges) {
                t_aEdgeClone.add(t_objLinkages);
            }
            for (GlycoEdge t_objEdgeSubstOne : t_aEdgeClone) {
                Linkage t_objLinkageSub;
                Substituent t_objSubstTwo;
                Linkage t_objLinkageSubstOne;
                GlycoNode t_objResidue = t_objEdgeSubstOne.getChild();
                if (!t_objNodeType.isSubstituent(t_objResidue)) continue;
                Substituent t_objSubstOne = (Substituent)t_objResidue;
                if (t_objSubstOne.getSubstituentType() == SubstituentType.AMINO && t_objSubstOne.getChildEdges().size() == 0) {
                    if (t_objEdgeSubstOne.getGlycosidicLinkages().size() != 1) continue;
                    t_objLinkageSubstOne = t_objEdgeSubstOne.getGlycosidicLinkages().get(0);
                    for (GlycoEdge t_objEdgeTwo : t_aEdgeClone) {
                        t_objResidue = t_objEdgeTwo.getChild();
                        if (!t_objNodeType.isSubstituent(t_objResidue)) continue;
                        t_objSubstTwo = (Substituent)t_objResidue;
                        if (t_objEdgeTwo.getGlycosidicLinkages().size() != 1) continue;
                        t_objLinkageSub = t_objEdgeTwo.getGlycosidicLinkages().get(0);
                        if (t_objSubstTwo.getSubstituentType() == SubstituentType.ACETYL) {
                            if (!this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                            t_objLinkageSub.setParentLinkageType(LinkageType.DEOXY);
                            t_objSubstTwo.setSubstituentType(SubstituentType.N_ACETYL);
                            a_objSugar.removeNode(t_objSubstOne);
                            this.m_aSubstituent.remove(t_objSubstOne);
                            continue;
                        }
                        if (t_objSubstTwo.getSubstituentType() == SubstituentType.GLYCOLYL) {
                            if (!this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                            t_objLinkageSub.setParentLinkageType(LinkageType.DEOXY);
                            t_objSubstTwo.setSubstituentType(SubstituentType.N_GLYCOLYL);
                            a_objSugar.removeNode(t_objSubstOne);
                            this.m_aSubstituent.remove(t_objSubstOne);
                            continue;
                        }
                        if (t_objSubstTwo.getSubstituentType() == SubstituentType.FORMYL) {
                            if (!this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                            t_objLinkageSub.setParentLinkageType(LinkageType.DEOXY);
                            t_objSubstTwo.setSubstituentType(SubstituentType.N_FORMYL);
                            a_objSugar.removeNode(t_objSubstOne);
                            this.m_aSubstituent.remove(t_objSubstOne);
                            continue;
                        }
                        if (t_objSubstTwo.getSubstituentType() == SubstituentType.AMIDINO) {
                            if (!this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                            t_objLinkageSub.setParentLinkageType(LinkageType.DEOXY);
                            t_objSubstTwo.setSubstituentType(SubstituentType.N_AMIDINO);
                            a_objSugar.removeNode(t_objSubstOne);
                            this.m_aSubstituent.remove(t_objSubstOne);
                            continue;
                        }
                        if (t_objSubstTwo.getSubstituentType() == SubstituentType.METHYL) {
                            if (!this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                            t_objLinkageSub.setParentLinkageType(LinkageType.DEOXY);
                            t_objSubstTwo.setSubstituentType(SubstituentType.N_METHYL);
                            a_objSugar.removeNode(t_objSubstOne);
                            this.m_aSubstituent.remove(t_objSubstOne);
                            continue;
                        }
                        if (t_objSubstTwo.getSubstituentType() == SubstituentType.SULFATE) {
                            if (!this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                            t_objLinkageSub.setParentLinkageType(LinkageType.DEOXY);
                            t_objSubstTwo.setSubstituentType(SubstituentType.N_SULFATE);
                            a_objSugar.removeNode(t_objSubstOne);
                            this.m_aSubstituent.remove(t_objSubstOne);
                            continue;
                        }
                        if (t_objSubstTwo.getSubstituentType() != SubstituentType.SUCCINATE || !this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                        t_objLinkageSub.setParentLinkageType(LinkageType.DEOXY);
                        t_objSubstTwo.setSubstituentType(SubstituentType.N_SUCCINATE);
                        a_objSugar.removeNode(t_objSubstOne);
                        this.m_aSubstituent.remove(t_objSubstOne);
                    }
                    continue;
                }
                if (t_objSubstOne.getSubstituentType() != SubstituentType.PHOSPHATE || t_objSubstOne.getChildEdges().size() != 0 || t_objEdgeSubstOne.getGlycosidicLinkages().size() != 1) continue;
                t_objLinkageSubstOne = t_objEdgeSubstOne.getGlycosidicLinkages().get(0);
                for (GlycoEdge t_objEdgeTwo : t_aEdgeClone) {
                    t_objResidue = t_objEdgeTwo.getChild();
                    if (!t_objNodeType.isSubstituent(t_objResidue)) continue;
                    t_objSubstTwo = (Substituent)t_objResidue;
                    if (t_objEdgeTwo.getGlycosidicLinkages().size() != 1) continue;
                    t_objLinkageSub = t_objEdgeTwo.getGlycosidicLinkages().get(0);
                    if (t_objSubstTwo.getSubstituentType() == SubstituentType.PHOSPHATE && t_objSubstOne != t_objSubstTwo) {
                        if (!this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                        t_objLinkageSub.setParentLinkageType(LinkageType.H_AT_OH);
                        t_objSubstTwo.setSubstituentType(SubstituentType.PYROPHOSPHATE);
                        a_objSugar.removeNode(t_objSubstOne);
                        this.m_aSubstituent.remove(t_objSubstOne);
                        continue;
                    }
                    if (t_objSubstTwo.getSubstituentType() == SubstituentType.PYROPHOSPHATE) {
                        if (!this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                        t_objLinkageSub.setParentLinkageType(LinkageType.H_AT_OH);
                        t_objSubstTwo.setSubstituentType(SubstituentType.TRIPHOSPHATE);
                        a_objSugar.removeNode(t_objSubstOne);
                        this.m_aSubstituent.remove(t_objSubstOne);
                        continue;
                    }
                    if (t_objSubstTwo.getSubstituentType() != SubstituentType.ETHANOLAMINE || !this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                    t_objLinkageSub.setParentLinkageType(LinkageType.H_AT_OH);
                    t_objSubstTwo.setSubstituentType(SubstituentType.PHOSPHO_ETHANOLAMINE);
                    a_objSugar.removeNode(t_objSubstOne);
                    this.m_aSubstituent.remove(t_objSubstOne);
                }
            }
        }
    }

    private void solveSzenarioThree(GlycoGraph a_objGraph) throws GlycoVisitorException, GlycoconjugateException {
        Iterator<Substituent> t_iterSubst = this.m_aSubstituent.iterator();
        while (t_iterSubst.hasNext()) {
            GlycoNode t_objParent;
            GlycoVisitorNodeType t_visNodeType;
            Substituent t_objSubSubst;
            boolean t_bFuse = false;
            Substituent t_objSubst = t_iterSubst.next();
            if (t_objSubst.getSubstituentType() == SubstituentType.ETHANOLAMINE) {
                if (t_objSubst.getParentEdge() == null || (t_objSubSubst = (t_visNodeType = new GlycoVisitorNodeType()).getSubstituent(t_objParent = t_objSubst.getParentEdge().getParent())) == null) continue;
                if (t_objSubSubst.getSubstituentType() == SubstituentType.PHOSPHATE) {
                    t_objSubSubst.setSubstituentType(SubstituentType.PHOSPHO_ETHANOLAMINE);
                    this.moveChilds(a_objGraph, t_objParent, t_objSubst);
                    t_bFuse = true;
                } else if (t_objSubSubst.getSubstituentType() == SubstituentType.PYROPHOSPHATE) {
                    t_objSubSubst.setSubstituentType(SubstituentType.DIPHOSPHO_ETHANOLAMINE);
                    this.moveChilds(a_objGraph, t_objParent, t_objSubst);
                    t_bFuse = true;
                }
                if (this.m_objRepeat == null || !t_bFuse || this.m_objRepeat.getRepeatLinkage().getParent() != t_objSubst) continue;
                this.m_objRepeat.setRepeatLinkage(this.m_objRepeat.getRepeatLinkage(), t_objParent, this.m_objRepeat.getRepeatLinkage().getChild());
                continue;
            }
            if (t_objSubst.getSubstituentType() == SubstituentType.PHOSPHATE) {
                if (t_objSubst.getParentEdge() == null || (t_objSubSubst = (t_visNodeType = new GlycoVisitorNodeType()).getSubstituent(t_objParent = t_objSubst.getParentEdge().getParent())) == null) continue;
                if (t_objSubSubst.getSubstituentType() == SubstituentType.PHOSPHATE) {
                    t_objSubSubst.setSubstituentType(SubstituentType.PYROPHOSPHATE);
                    this.moveChilds(a_objGraph, t_objParent, t_objSubst);
                    t_bFuse = true;
                } else if (t_objSubSubst.getSubstituentType() == SubstituentType.PYROPHOSPHATE) {
                    t_objSubSubst.setSubstituentType(SubstituentType.TRIPHOSPHATE);
                    this.moveChilds(a_objGraph, t_objParent, t_objSubst);
                    t_bFuse = true;
                }
                if (this.m_objRepeat == null || !t_bFuse || this.m_objRepeat.getRepeatLinkage().getParent() != t_objSubst) continue;
                this.m_objRepeat.setRepeatLinkage(this.m_objRepeat.getRepeatLinkage(), t_objParent, this.m_objRepeat.getRepeatLinkage().getChild());
                continue;
            }
            if (t_objSubst.getSubstituentType() == SubstituentType.PYROPHOSPHATE) {
                if (t_objSubst.getParentEdge() == null || (t_objSubSubst = (t_visNodeType = new GlycoVisitorNodeType()).getSubstituent(t_objParent = t_objSubst.getParentEdge().getParent())) == null) continue;
                if (t_objSubSubst.getSubstituentType() == SubstituentType.PHOSPHATE) {
                    t_objSubSubst.setSubstituentType(SubstituentType.TRIPHOSPHATE);
                    this.moveChilds(a_objGraph, t_objParent, t_objSubst);
                    t_bFuse = true;
                }
                if (this.m_objRepeat == null || !t_bFuse || this.m_objRepeat.getRepeatLinkage().getParent() != t_objSubst) continue;
                this.m_objRepeat.setRepeatLinkage(this.m_objRepeat.getRepeatLinkage(), t_objParent, this.m_objRepeat.getRepeatLinkage().getChild());
                continue;
            }
            if (t_objSubst.getSubstituentType() == SubstituentType.PHOSPHO_ETHANOLAMINE) {
                if (t_objSubst.getParentEdge() == null || (t_objSubSubst = (t_visNodeType = new GlycoVisitorNodeType()).getSubstituent(t_objParent = t_objSubst.getParentEdge().getParent())) == null) continue;
                if (t_objSubSubst.getSubstituentType() == SubstituentType.PHOSPHATE) {
                    t_objSubSubst.setSubstituentType(SubstituentType.DIPHOSPHO_ETHANOLAMINE);
                    this.moveChilds(a_objGraph, t_objParent, t_objSubst);
                    t_bFuse = true;
                }
                if (this.m_objRepeat == null || !t_bFuse || this.m_objRepeat.getRepeatLinkage().getParent() != t_objSubst) continue;
                this.m_objRepeat.setRepeatLinkage(this.m_objRepeat.getRepeatLinkage(), t_objParent, this.m_objRepeat.getRepeatLinkage().getChild());
                continue;
            }
            if (t_objSubst.getSubstituentType() == SubstituentType.SULFATE) {
                if (t_objSubst.getParentEdge() == null || (t_objSubSubst = (t_visNodeType = new GlycoVisitorNodeType()).getSubstituent(t_objParent = t_objSubst.getParentEdge().getParent())) == null) continue;
                if (t_objSubSubst.getSubstituentType() == SubstituentType.AMINO) {
                    t_objSubSubst.setSubstituentType(SubstituentType.N_SULFATE);
                    this.moveChilds(a_objGraph, t_objParent, t_objSubst);
                    t_bFuse = true;
                }
                if (this.m_objRepeat == null || !t_bFuse || this.m_objRepeat.getRepeatLinkage().getParent() != t_objSubst) continue;
                this.m_objRepeat.setRepeatLinkage(this.m_objRepeat.getRepeatLinkage(), t_objParent, this.m_objRepeat.getRepeatLinkage().getChild());
                continue;
            }
            if (t_objSubst.getSubstituentType() == SubstituentType.METHYL) {
                if (t_objSubst.getParentEdge() == null || (t_objSubSubst = (t_visNodeType = new GlycoVisitorNodeType()).getSubstituent(t_objParent = t_objSubst.getParentEdge().getParent())) == null) continue;
                if (t_objSubSubst.getSubstituentType() == SubstituentType.AMINO) {
                    t_objSubSubst.setSubstituentType(SubstituentType.N_METHYL);
                    this.moveChilds(a_objGraph, t_objParent, t_objSubst);
                    t_bFuse = true;
                }
                if (this.m_objRepeat == null || !t_bFuse || this.m_objRepeat.getRepeatLinkage().getParent() != t_objSubst) continue;
                this.m_objRepeat.setRepeatLinkage(this.m_objRepeat.getRepeatLinkage(), t_objParent, this.m_objRepeat.getRepeatLinkage().getChild());
                continue;
            }
            if (t_objSubst.getSubstituentType() == SubstituentType.GLYCOLYL) {
                if (t_objSubst.getParentEdge() == null || (t_objSubSubst = (t_visNodeType = new GlycoVisitorNodeType()).getSubstituent(t_objParent = t_objSubst.getParentEdge().getParent())) == null) continue;
                if (t_objSubSubst.getSubstituentType() == SubstituentType.AMINO) {
                    t_objSubSubst.setSubstituentType(SubstituentType.N_GLYCOLYL);
                    this.moveChilds(a_objGraph, t_objParent, t_objSubst);
                    t_bFuse = true;
                }
                if (this.m_objRepeat == null || !t_bFuse || this.m_objRepeat.getRepeatLinkage().getParent() != t_objSubst) continue;
                this.m_objRepeat.setRepeatLinkage(this.m_objRepeat.getRepeatLinkage(), t_objParent, this.m_objRepeat.getRepeatLinkage().getChild());
                continue;
            }
            if (t_objSubst.getSubstituentType() == SubstituentType.FORMYL) {
                if (t_objSubst.getParentEdge() == null || (t_objSubSubst = (t_visNodeType = new GlycoVisitorNodeType()).getSubstituent(t_objParent = t_objSubst.getParentEdge().getParent())) == null) continue;
                if (t_objSubSubst.getSubstituentType() == SubstituentType.AMINO) {
                    t_objSubSubst.setSubstituentType(SubstituentType.N_FORMYL);
                    this.moveChilds(a_objGraph, t_objParent, t_objSubst);
                    t_bFuse = true;
                }
                if (this.m_objRepeat == null || !t_bFuse || this.m_objRepeat.getRepeatLinkage().getParent() != t_objSubst) continue;
                this.m_objRepeat.setRepeatLinkage(this.m_objRepeat.getRepeatLinkage(), t_objParent, this.m_objRepeat.getRepeatLinkage().getChild());
                continue;
            }
            if (t_objSubst.getSubstituentType() == SubstituentType.AMIDINO) {
                if (t_objSubst.getParentEdge() == null || (t_objSubSubst = (t_visNodeType = new GlycoVisitorNodeType()).getSubstituent(t_objParent = t_objSubst.getParentEdge().getParent())) == null) continue;
                if (t_objSubSubst.getSubstituentType() == SubstituentType.AMINO) {
                    t_objSubSubst.setSubstituentType(SubstituentType.N_AMIDINO);
                    this.moveChilds(a_objGraph, t_objParent, t_objSubst);
                    t_bFuse = true;
                }
                if (this.m_objRepeat == null || !t_bFuse || this.m_objRepeat.getRepeatLinkage().getParent() != t_objSubst) continue;
                this.m_objRepeat.setRepeatLinkage(this.m_objRepeat.getRepeatLinkage(), t_objParent, this.m_objRepeat.getRepeatLinkage().getChild());
                continue;
            }
            if (t_objSubst.getSubstituentType() == SubstituentType.ACETYL) {
                if (t_objSubst.getParentEdge() == null || (t_objSubSubst = (t_visNodeType = new GlycoVisitorNodeType()).getSubstituent(t_objParent = t_objSubst.getParentEdge().getParent())) == null) continue;
                if (t_objSubSubst.getSubstituentType() == SubstituentType.AMINO) {
                    t_objSubSubst.setSubstituentType(SubstituentType.N_ACETYL);
                    this.moveChilds(a_objGraph, t_objParent, t_objSubst);
                    t_bFuse = true;
                }
                if (this.m_objRepeat == null || !t_bFuse || this.m_objRepeat.getRepeatLinkage().getParent() != t_objSubst) continue;
                this.m_objRepeat.setRepeatLinkage(this.m_objRepeat.getRepeatLinkage(), t_objParent, this.m_objRepeat.getRepeatLinkage().getChild());
                continue;
            }
            if (t_objSubst.getSubstituentType() != SubstituentType.SUCCINATE || t_objSubst.getParentEdge() == null || (t_objSubSubst = (t_visNodeType = new GlycoVisitorNodeType()).getSubstituent(t_objParent = t_objSubst.getParentEdge().getParent())) == null) continue;
            if (t_objSubSubst.getSubstituentType() == SubstituentType.AMINO) {
                t_objSubSubst.setSubstituentType(SubstituentType.N_SUCCINATE);
                this.moveChilds(a_objGraph, t_objParent, t_objSubst);
                t_bFuse = true;
            }
            if (this.m_objRepeat == null || !t_bFuse || this.m_objRepeat.getRepeatLinkage().getParent() != t_objSubst) continue;
            this.m_objRepeat.setRepeatLinkage(this.m_objRepeat.getRepeatLinkage(), t_objParent, this.m_objRepeat.getRepeatLinkage().getChild());
        }
    }

    private void moveChilds(GlycoGraph a_objGraph, GlycoNode a_objSubst, GlycoNode a_objRemoveSubst) throws GlycoconjugateException {
        ArrayList<GlycoEdge> t_aTemp = new ArrayList<GlycoEdge>();
        Iterator<GlycoEdge> t_iterChilds = a_objRemoveSubst.getChildEdges().iterator();
        while (t_iterChilds.hasNext()) {
            t_aTemp.add(t_iterChilds.next());
        }
        for (GlycoEdge t_objEdge : t_aTemp) {
            GlycoNode t_objNode = t_objEdge.getChild();
            a_objGraph.removeEdge(t_objEdge);
            a_objGraph.addEdge(a_objSubst, t_objNode, t_objEdge);
        }
        a_objGraph.removeNode(a_objRemoveSubst);
    }

    private void solveSzenarioFour(GlycoGraph a_objSugar) throws GlycoVisitorException, GlycoconjugateException {
        GlycoVisitorNodeType t_objNodeType = new GlycoVisitorNodeType();
        for (Monosaccharide t_objMS : this.m_aMonosaccharides) {
            ArrayList<GlycoEdge> t_aEdges = t_objMS.getChildEdges();
            if (t_aEdges.size() <= 1) continue;
            ArrayList<GlycoEdge> t_aEdgeClone = new ArrayList<GlycoEdge>();
            for (GlycoEdge t_objLinkages : t_aEdges) {
                t_aEdgeClone.add(t_objLinkages);
            }
            for (GlycoEdge t_objEdgeSubstOne : t_aEdgeClone) {
                Linkage t_objLinkageSub;
                Substituent t_objSubstTwo;
                Linkage t_objLinkageSubstOne;
                GlycoNode t_objResidue = t_objEdgeSubstOne.getChild();
                if (!t_objNodeType.isSubstituent(t_objResidue)) continue;
                Substituent t_objSubstOne = (Substituent)t_objResidue;
                if (t_objSubstOne.getSubstituentType() == SubstituentType.AMINO && t_objSubstOne.getChildEdges().size() == 0) {
                    if (t_objEdgeSubstOne.getGlycosidicLinkages().size() != 1) continue;
                    t_objLinkageSubstOne = t_objEdgeSubstOne.getGlycosidicLinkages().get(0);
                    for (GlycoEdge t_objEdgeTwo : t_aEdgeClone) {
                        t_objResidue = t_objEdgeTwo.getChild();
                        if (!t_objNodeType.isSubstituent(t_objResidue)) continue;
                        t_objSubstTwo = (Substituent)t_objResidue;
                        if (t_objEdgeTwo.getGlycosidicLinkages().size() != 1) continue;
                        t_objLinkageSub = t_objEdgeTwo.getGlycosidicLinkages().get(0);
                        if (t_objSubstTwo.getSubstituentType() == SubstituentType.N_ACETYL) {
                            if (!this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                            t_objLinkageSub.setParentLinkageType(LinkageType.DEOXY);
                            a_objSugar.removeNode(t_objSubstOne);
                            this.m_aSubstituent.remove(t_objSubstOne);
                            continue;
                        }
                        if (t_objSubstTwo.getSubstituentType() == SubstituentType.N_GLYCOLYL) {
                            if (!this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                            t_objLinkageSub.setParentLinkageType(LinkageType.DEOXY);
                            a_objSugar.removeNode(t_objSubstOne);
                            this.m_aSubstituent.remove(t_objSubstOne);
                            continue;
                        }
                        if (t_objSubstTwo.getSubstituentType() == SubstituentType.N_FORMYL) {
                            if (!this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                            t_objLinkageSub.setParentLinkageType(LinkageType.DEOXY);
                            a_objSugar.removeNode(t_objSubstOne);
                            this.m_aSubstituent.remove(t_objSubstOne);
                            continue;
                        }
                        if (t_objSubstTwo.getSubstituentType() == SubstituentType.N_AMIDINO) {
                            if (!this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                            t_objLinkageSub.setParentLinkageType(LinkageType.DEOXY);
                            a_objSugar.removeNode(t_objSubstOne);
                            this.m_aSubstituent.remove(t_objSubstOne);
                            continue;
                        }
                        if (t_objSubstTwo.getSubstituentType() == SubstituentType.N_METHYL) {
                            if (!this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                            t_objLinkageSub.setParentLinkageType(LinkageType.DEOXY);
                            a_objSugar.removeNode(t_objSubstOne);
                            this.m_aSubstituent.remove(t_objSubstOne);
                            continue;
                        }
                        if (t_objSubstTwo.getSubstituentType() != SubstituentType.N_SULFATE || !this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                        t_objLinkageSub.setParentLinkageType(LinkageType.DEOXY);
                        a_objSugar.removeNode(t_objSubstOne);
                        this.m_aSubstituent.remove(t_objSubstOne);
                    }
                    continue;
                }
                if (t_objSubstOne.getSubstituentType() != SubstituentType.PHOSPHATE || t_objSubstOne.getChildEdges().size() != 0 || t_objEdgeSubstOne.getGlycosidicLinkages().size() != 1) continue;
                t_objLinkageSubstOne = t_objEdgeSubstOne.getGlycosidicLinkages().get(0);
                for (GlycoEdge t_objEdgeTwo : t_aEdgeClone) {
                    t_objResidue = t_objEdgeTwo.getChild();
                    if (!t_objNodeType.isSubstituent(t_objResidue)) continue;
                    t_objSubstTwo = (Substituent)t_objResidue;
                    if (t_objEdgeTwo.getGlycosidicLinkages().size() != 1) continue;
                    t_objLinkageSub = t_objEdgeTwo.getGlycosidicLinkages().get(0);
                    if (t_objSubstTwo.getSubstituentType() != SubstituentType.PHOSPHO_ETHANOLAMINE || !this.compareArrays(t_objLinkageSub.getParentLinkages(), t_objLinkageSubstOne.getParentLinkages())) continue;
                    t_objLinkageSub.setParentLinkageType(LinkageType.H_AT_OH);
                    a_objSugar.removeNode(t_objSubstOne);
                    this.m_aSubstituent.remove(t_objSubstOne);
                }
            }
        }
    }

    private void solveSzenarioFive(GlycoGraph a_objSugar) throws GlycoVisitorException, GlycoconjugateException {
        GlycoVisitorNodeType t_objNodeType = new GlycoVisitorNodeType();
        for (Monosaccharide t_objMSGro : this.m_aMonosaccharides) {
            if (t_objMSGro.getSuperclass() != Superclass.TRI) continue;
            ArrayList<GlycoEdge> t_aLinkages = t_objMSGro.getChildEdges();
            ArrayList<GlycoEdge> t_aEdgeClone = new ArrayList<GlycoEdge>();
            for (GlycoEdge t_objLinkages : t_aLinkages) {
                t_aEdgeClone.add(t_objLinkages);
            }
            for (GlycoEdge t_objEdgeAmino : t_aEdgeClone) {
                Substituent t_objAmino;
                GlycoNode t_objResidue = t_objEdgeAmino.getChild();
                if (!t_objNodeType.isSubstituent(t_objResidue) || (t_objAmino = (Substituent)t_objResidue).getSubstituentType() != SubstituentType.AMINO || t_objEdgeAmino.getGlycosidicLinkages().size() != 1) continue;
                GlycoEdge t_objEdgeParent = t_objMSGro.getParentEdge();
                GlycoNode t_objMSParent = t_objEdgeParent.getParent();
                if (t_objEdgeParent == null || !this.samePosition(t_objEdgeParent, t_objEdgeAmino)) continue;
                a_objSugar.removeEdge(t_objEdgeAmino);
                a_objSugar.removeEdge(t_objEdgeParent);
                GlycoEdge t_objEdge = new GlycoEdge();
                Linkage t_objLink = new Linkage();
                t_objLink.addChildLinkage(1);
                t_objLink.setChildLinkageType(LinkageType.NONMONOSACCHARID);
                t_objLink.setParentLinkages(t_objEdgeParent.getGlycosidicLinkages().get(0).getParentLinkages());
                t_objLink.setParentLinkageType(LinkageType.DEOXY);
                t_objEdge.addGlycosidicLinkage(t_objLink);
                a_objSugar.addEdge(t_objMSParent, t_objResidue, t_objEdge);
                t_objEdge = new GlycoEdge();
                t_objLink = new Linkage();
                t_objLink.addParentLinkage(1);
                t_objLink.setParentLinkageType(LinkageType.NONMONOSACCHARID);
                t_objLink.setChildLinkageType(LinkageType.DEOXY);
                t_objLink.setChildLinkages(t_objEdgeParent.getGlycosidicLinkages().get(0).getChildLinkages());
                t_objEdge.addGlycosidicLinkage(t_objLink);
                a_objSugar.addEdge(t_objResidue, t_objMSGro, t_objEdge);
            }
        }
    }

    private boolean samePosition(GlycoEdge a_objEdgeParent, GlycoEdge a_objEdgeAmino) {
        if (a_objEdgeAmino.getGlycosidicLinkages().size() != 1 || a_objEdgeParent.getGlycosidicLinkages().size() != 1) {
            return false;
        }
        return this.compareArrays(a_objEdgeAmino.getGlycosidicLinkages().get(0).getParentLinkages(), a_objEdgeParent.getGlycosidicLinkages().get(0).getChildLinkages());
    }

    private boolean compareArrays(ArrayList<Integer> a_aOne, ArrayList<Integer> a_aTwo) {
        if (a_aOne.size() != a_aTwo.size()) {
            return false;
        }
        Collections.sort(a_aOne);
        Collections.sort(a_aTwo);
        for (int t_iCounter = 0; t_iCounter < a_aOne.size(); ++t_iCounter) {
            if (a_aOne.get(t_iCounter) == a_aTwo.get(t_iCounter)) continue;
            return false;
        }
        return true;
    }
}

