/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.ListProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;

public class FontShorthandProperty
extends ListProperty {
    private void addProperty(Property prop, int pos) {
        while (this.list.size() < pos + 1) {
            this.list.add(null);
        }
        this.list.set(pos, prop);
    }

    public static class Maker
    extends PropertyMaker {
        private static final int[] PROP_IDS = new int[]{103, 101, 144, 106, 107, 108};

        public Maker(int propId) {
            super(propId);
        }

        public Property make(PropertyList propertyList, String value, FObj fo) throws PropertyException {
            try {
                FontShorthandProperty newProp = new FontShorthandProperty();
                newProp.setSpecifiedValue(value);
                String specVal = value;
                Property prop = null;
                if ("inherit".equals(specVal)) {
                    int i = PROP_IDS.length;
                    while (--i >= 0) {
                        prop = propertyList.getFromParent(PROP_IDS[i]);
                        newProp.addProperty(prop, i);
                    }
                } else {
                    int pos = PROP_IDS.length;
                    while (--pos >= 0) {
                        newProp.addProperty(null, pos);
                    }
                    prop = this.checkEnumValues(specVal);
                    if (prop == null) {
                        int quoteIndex;
                        int spaceIndex = value.indexOf(32);
                        int n = quoteIndex = value.indexOf(39) == -1 ? value.indexOf(34) : value.indexOf(39);
                        if (spaceIndex == -1 || quoteIndex != -1 && spaceIndex > quoteIndex) {
                            throw new PropertyException("Invalid property value: font=\"" + value + "\"");
                        }
                        PropertyMaker m = null;
                        int fromIndex = spaceIndex + 1;
                        int toIndex = specVal.length();
                        boolean fontFamilyParsed = false;
                        int commaIndex = value.indexOf(44);
                        while (!fontFamilyParsed) {
                            if (commaIndex == -1) {
                                if (quoteIndex != -1) {
                                    fromIndex = quoteIndex;
                                }
                                m = FObj.getPropertyMakerFor(PROP_IDS[1]);
                                prop = m.make(propertyList, specVal.substring(fromIndex), fo);
                                newProp.addProperty(prop, 1);
                                fontFamilyParsed = true;
                                continue;
                            }
                            if (quoteIndex != -1 && quoteIndex < commaIndex) {
                                fromIndex = quoteIndex;
                                quoteIndex = -1;
                            } else {
                                fromIndex = value.lastIndexOf(32, commaIndex) + 1;
                            }
                            commaIndex = -1;
                        }
                        toIndex = fromIndex - 1;
                        int slashIndex = (value = specVal.substring(fromIndex = value.lastIndexOf(32, toIndex - 1) + 1, toIndex)).indexOf(47);
                        String fontSize = value.substring(0, slashIndex == -1 ? value.length() : slashIndex);
                        m = FObj.getPropertyMakerFor(PROP_IDS[0]);
                        prop = m.make(propertyList, fontSize, fo);
                        propertyList.putExplicit(PROP_IDS[0], prop);
                        newProp.addProperty(prop, 0);
                        if (slashIndex != -1) {
                            String lineHeight = value.substring(slashIndex + 1);
                            m = FObj.getPropertyMakerFor(PROP_IDS[2]);
                            prop = m.make(propertyList, lineHeight, fo);
                            newProp.addProperty(prop, 2);
                        }
                        if (fromIndex != 0) {
                            toIndex = fromIndex - 1;
                            value = specVal.substring(0, toIndex);
                            fromIndex = 0;
                            spaceIndex = value.indexOf(32);
                            do {
                                toIndex = spaceIndex == -1 ? value.length() : spaceIndex;
                                String val = value.substring(fromIndex, toIndex);
                                int i = 6;
                                while (--i >= 3) {
                                    if (newProp.list.get(i) != null || (prop = (m = FObj.getPropertyMakerFor(PROP_IDS[i])).checkEnumValues(val = m.checkValueKeywords(val))) == null) continue;
                                    newProp.addProperty(prop, i);
                                }
                                fromIndex = toIndex + 1;
                                spaceIndex = value.indexOf(32, fromIndex);
                            } while (toIndex != value.length());
                        }
                    } else {
                        Property.log.warn("Enum values other than \"inherit\" not yet supported for the font shorthand.");
                        return null;
                    }
                }
                if (newProp.list.get(0) == null || newProp.list.get(1) == null) {
                    throw new PropertyException("Invalid property value: font-size and font-family are required for the font shorthand\nfont=\"" + value + "\"");
                }
                return newProp;
            }
            catch (PropertyException pe) {
                pe.setLocator(propertyList.getFObj().getLocator());
                pe.setPropertyName(this.getName());
                throw pe;
            }
        }
    }
}

