/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.AbstractCsvConverter;
import com.opencsv.bean.AbstractMappingStrategy;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.BeanFieldJoinIntegerIndex;
import com.opencsv.bean.BeanFieldSingleValue;
import com.opencsv.bean.BeanFieldSplit;
import com.opencsv.bean.ComplexFieldMapEntry;
import com.opencsv.bean.CsvBindAndJoinByPosition;
import com.opencsv.bean.CsvBindAndSplitByPosition;
import com.opencsv.bean.CsvBindByPosition;
import com.opencsv.bean.CsvConverter;
import com.opencsv.bean.CsvCustomBindByPosition;
import com.opencsv.bean.FieldMap;
import com.opencsv.bean.FieldMapByPosition;
import com.opencsv.bean.FieldMapByPositionEntry;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.ArrayUtils;

public class ColumnPositionMappingStrategy<T>
extends AbstractMappingStrategy<String, Integer, ComplexFieldMapEntry<String, Integer, T>, T> {
    private boolean columnsExplicitlySet = false;
    private FieldMapByPosition<T> fieldMap;
    private Comparator<Integer> writeOrder;
    private Integer[] columnIndexForWriting = null;

    @Override
    public void captureHeader(CSVReader reader) throws IOException {
        if (this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("type.unset"));
        }
        String[] firstLine = ArrayUtils.nullToEmpty(reader.peek());
        this.fieldMap.setMaxIndex(firstLine.length - 1);
        if (!this.columnsExplicitlySet) {
            this.headerIndex.clear();
            for (FieldMapByPositionEntry<T> entry : this.fieldMap) {
                Field f = entry.getField().getField();
                if (f.getAnnotation(CsvCustomBindByPosition.class) == null && f.getAnnotation(CsvBindAndSplitByPosition.class) == null && f.getAnnotation(CsvBindAndJoinByPosition.class) == null && f.getAnnotation(CsvBindByPosition.class) == null) continue;
                this.headerIndex.put(entry.getPosition(), f.getName().toUpperCase().trim());
            }
        }
    }

    @Override
    protected Integer chooseMultivaluedFieldIndexFromHeaderIndex(int index) {
        return index;
    }

    @Override
    protected BeanField<T, Integer> findField(int col) {
        if (this.columnIndexForWriting != null) {
            return col < this.columnIndexForWriting.length ? this.fieldMap.get(this.columnIndexForWriting[col]) : null;
        }
        return this.fieldMap.get(col);
    }

    @Override
    public String[] generateHeader(T bean) throws CsvRequiredFieldEmptyException {
        String[] h = super.generateHeader(bean);
        this.columnIndexForWriting = new Integer[h.length];
        Arrays.setAll(this.columnIndexForWriting, i -> i);
        Arrays.sort(this.columnIndexForWriting, this.writeOrder);
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public String getColumnName(int col) {
        return this.headerIndex.getByPosition(col);
    }

    public String[] getColumnMapping() {
        return this.headerIndex.getHeaderIndex();
    }

    public void setColumnMapping(String ... columnMapping) {
        if (columnMapping != null) {
            this.headerIndex.initializeHeaderIndex(columnMapping);
        } else {
            this.headerIndex.clear();
        }
        this.columnsExplicitlySet = true;
        if (this.getType() != null) {
            this.loadFieldMap();
        }
    }

    @Override
    protected void loadAnnotatedFieldMap(ListValuedMap<Class<?>, Field> fields) {
        for (Map.Entry classAndField : fields.entries()) {
            String format;
            String capture;
            String fieldWriteLocale;
            String fieldLocale;
            boolean required;
            Object converter;
            Annotation annotation;
            Class localType = (Class)classAndField.getKey();
            Field localField = (Field)classAndField.getValue();
            if (localField.isAnnotationPresent(CsvCustomBindByPosition.class)) {
                annotation = localField.getAnnotation(CsvCustomBindByPosition.class);
                converter = annotation.converter();
                BeanField bean = this.instantiateCustomConverter(converter);
                bean.setType(localType);
                bean.setField(localField);
                required = annotation.required();
                bean.setRequired(required);
                this.fieldMap.put(annotation.position(), bean);
                continue;
            }
            if (localField.isAnnotationPresent(CsvBindAndSplitByPosition.class)) {
                annotation = localField.getAnnotation(CsvBindAndSplitByPosition.class);
                required = annotation.required();
                fieldLocale = annotation.locale();
                fieldWriteLocale = annotation.writeLocaleEqualsReadLocale() ? fieldLocale : annotation.writeLocale();
                String splitOn = annotation.splitOn();
                String writeDelimiter = annotation.writeDelimiter();
                Class<? extends Collection> collectionType = annotation.collectionType();
                Class<?> elementType = annotation.elementType();
                Class<? extends AbstractCsvConverter> splitConverter = annotation.converter();
                capture = annotation.capture();
                format = annotation.format();
                CsvConverter converter2 = this.determineConverter(localField, elementType, fieldLocale, fieldWriteLocale, splitConverter);
                this.fieldMap.put(annotation.position(), new BeanFieldSplit(localType, localField, required, this.errorLocale, converter2, splitOn, writeDelimiter, collectionType, elementType, capture, format));
                continue;
            }
            if (localField.isAnnotationPresent(CsvBindAndJoinByPosition.class)) {
                annotation = localField.getAnnotation(CsvBindAndJoinByPosition.class);
                required = annotation.required();
                fieldLocale = annotation.locale();
                fieldWriteLocale = annotation.writeLocaleEqualsReadLocale() ? fieldLocale : annotation.writeLocale();
                Class<?> elementType = annotation.elementType();
                Class<? extends MultiValuedMap> mapType = annotation.mapType();
                Class<? extends AbstractCsvConverter> joinConverter = annotation.converter();
                capture = annotation.capture();
                format = annotation.format();
                CsvConverter converter3 = this.determineConverter(localField, elementType, fieldLocale, fieldWriteLocale, joinConverter);
                this.fieldMap.putComplex(annotation.position(), (BeanField<T, Integer>)new BeanFieldJoinIntegerIndex(localType, localField, required, this.errorLocale, converter3, mapType, capture, format));
                continue;
            }
            annotation = localField.getAnnotation(CsvBindByPosition.class);
            required = annotation.required();
            fieldLocale = annotation.locale();
            fieldWriteLocale = annotation.writeLocaleEqualsReadLocale() ? fieldLocale : annotation.writeLocale();
            capture = annotation.capture();
            format = annotation.format();
            converter = this.determineConverter(localField, localField.getType(), fieldLocale, fieldWriteLocale, null);
            this.fieldMap.put(annotation.position(), new BeanFieldSingleValue(localType, localField, required, this.errorLocale, (CsvConverter)converter, capture, format));
        }
    }

    @Override
    protected void loadUnadornedFieldMap(ListValuedMap<Class<?>, Field> fields) {
        for (Map.Entry classAndField : fields.entries()) {
            Class localType = (Class)classAndField.getKey();
            Field localField = (Field)classAndField.getValue();
            CsvConverter converter = this.determineConverter(localField, localField.getType(), null, null, null);
            int[] indices = this.headerIndex.getByName(localField.getName());
            if (indices.length == 0) continue;
            this.fieldMap.put(indices[0], new BeanFieldSingleValue(localType, localField, false, this.errorLocale, converter, null, null));
        }
    }

    @Override
    protected Set<Class<? extends Annotation>> getBindingAnnotations() {
        return new HashSet<Class<? extends Annotation>>(Arrays.asList(CsvBindByPosition.class, CsvCustomBindByPosition.class, CsvBindAndJoinByPosition.class, CsvBindAndSplitByPosition.class));
    }

    @Override
    protected void initializeFieldMap() {
        this.fieldMap = new FieldMapByPosition(this.errorLocale);
        this.fieldMap.setColumnOrderOnWrite(this.writeOrder);
    }

    @Override
    protected void verifyLineLength(int numberOfFields) throws CsvRequiredFieldEmptyException {
        if (!this.headerIndex.isEmpty()) {
            StringBuilder sb = null;
            for (int i = numberOfFields; i <= this.headerIndex.findMaxIndex(); ++i) {
                BeanField<T, Integer> f = this.findField(i);
                if (f == null || !f.isRequired()) continue;
                if (sb == null) {
                    sb = new StringBuilder(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("multiple.required.field.empty"));
                }
                sb.append(' ');
                sb.append(f.getField().getName());
            }
            if (sb != null) {
                throw new CsvRequiredFieldEmptyException(this.type, sb.toString());
            }
        }
    }

    @Override
    public String findHeader(int col) {
        return Integer.toString(col);
    }

    @Override
    protected FieldMap<String, Integer, ? extends ComplexFieldMapEntry<String, Integer, T>, T> getFieldMap() {
        return this.fieldMap;
    }

    public void setColumnOrderOnWrite(Comparator<Integer> writeOrder) {
        this.writeOrder = writeOrder;
        if (this.fieldMap != null) {
            this.fieldMap.setColumnOrderOnWrite(this.writeOrder);
        }
    }
}

