/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.NSPanelComponent;
import chrriis.dj.nativeswing.swtimpl.WebBrowserObject;
import chrriis.dj.nativeswing.swtimpl.components.FlashPlayerCommandEvent;
import chrriis.dj.nativeswing.swtimpl.components.FlashPlayerListener;
import chrriis.dj.nativeswing.swtimpl.components.FlashPluginOptions;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserCommandEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFlashPlayer
extends NSPanelComponent {
    private static final String SET_CUSTOM_JAVASCRIPT_DEFINITIONS_OPTION_KEY = "Flash Player Custom Javascript definitions";
    private final ResourceBundle RESOURCES;
    private JPanel webBrowserPanel;
    private JWebBrowser webBrowser;
    private JPanel controlBarPane;
    private JButton playButton;
    private JButton pauseButton;
    private JButton stopButton;
    private WebBrowserObject webBrowserObject;
    private volatile String customJavascriptDefinitions;
    private volatile FlashPluginOptions options;
    private List<ClassLoader> referenceClassLoaderList;

    static {
        WebServer.getDefaultWebServer().addContentProvider(new WebServer.WebServerContentProvider(){

            public WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest httpRequest) {
                if ("/crossdomain.xml".equals(httpRequest.getResourcePath())) {
                    return new WebServer.WebServerContent(){

                        public InputStream getInputStream() {
                            return 1.getInputStream("<?xml version=\"1.0\"?>" + Utils.LINE_SEPARATOR + "<!DOCTYPE cross-domain-policy SYSTEM \"http://www.adobe.com/xml/dtds/cross-domain-policy.dtd\">" + Utils.LINE_SEPARATOR + "<cross-domain-policy>" + Utils.LINE_SEPARATOR + "  <site-control permitted-cross-domain-policies=\"all\"/>" + Utils.LINE_SEPARATOR + "  <allow-access-from domain=\"*\" secure=\"false\"/>" + Utils.LINE_SEPARATOR + "  <allow-http-request-headers-from domain=\"*\" headers=\"*\" secure=\"false\"/>" + Utils.LINE_SEPARATOR + "</cross-domain-policy>");
                        }
                    };
                }
                return null;
            }
        });
    }

    public static NSOption setCustomJavascriptDefinitions(final String javascript) {
        return new NSOption(SET_CUSTOM_JAVASCRIPT_DEFINITIONS_OPTION_KEY){

            public Object getOptionValue() {
                return javascript;
            }
        };
    }

    public JFlashPlayer(NSOption ... options) {
        String className = JFlashPlayer.class.getName();
        this.RESOURCES = ResourceBundle.getBundle(String.valueOf(className.substring(0, className.lastIndexOf(46)).replace('.', '/')) + "/resource/FlashPlayer");
        this.referenceClassLoaderList = new ArrayList<ClassLoader>(1);
        Map<Object, Object> optionMap = NSOption.createOptionMap(options);
        this.customJavascriptDefinitions = (String)optionMap.get(SET_CUSTOM_JAVASCRIPT_DEFINITIONS_OPTION_KEY);
        this.webBrowser = new JWebBrowser(options);
        this.initialize(this.webBrowser.getNativeComponent());
        this.webBrowserObject = new NWebBrowserObject(this);
        this.webBrowser.addWebBrowserListener(new WebBrowserAdapter(){

            public void commandReceived(WebBrowserCommandEvent e) {
                String command = e.getCommand();
                Object[] parameters = e.getParameters();
                boolean isInternal = command.startsWith("[Chrriis]");
                FlashPlayerCommandEvent ev = null;
                FlashPlayerListener[] flashPlayerListenerArray = JFlashPlayer.this.getFlashPlayerListeners();
                int n = flashPlayerListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FlashPlayerListener listener = flashPlayerListenerArray[n2];
                    if (!isInternal || listener.getClass().getName().startsWith("chrriis.")) {
                        if (ev == null) {
                            ev = new FlashPlayerCommandEvent(JFlashPlayer.this, command, parameters);
                        }
                        listener.commandReceived(ev);
                    }
                    ++n2;
                }
            }
        });
        this.webBrowserPanel = new JPanel(new BorderLayout());
        this.webBrowserPanel.add((Component)this.webBrowser, "Center");
        this.add((Component)this.webBrowserPanel, "Center");
        this.controlBarPane = new JPanel(new FlowLayout(1, 4, 2));
        this.playButton = new JButton(this.createIcon("PlayIcon"));
        this.playButton.setEnabled(false);
        this.playButton.setToolTipText(this.RESOURCES.getString("PlayText"));
        this.playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFlashPlayer.this.play();
            }
        });
        this.controlBarPane.add(this.playButton);
        this.pauseButton = new JButton(this.createIcon("PauseIcon"));
        this.pauseButton.setEnabled(false);
        this.pauseButton.setToolTipText(this.RESOURCES.getString("PauseText"));
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFlashPlayer.this.pause();
            }
        });
        this.controlBarPane.add(this.pauseButton);
        this.stopButton = new JButton(this.createIcon("StopIcon"));
        this.stopButton.setEnabled(false);
        this.stopButton.setToolTipText(this.RESOURCES.getString("StopText"));
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFlashPlayer.this.stop();
            }
        });
        this.controlBarPane.add(this.stopButton);
        this.add((Component)this.controlBarPane, "South");
        this.adjustBorder();
        this.setControlBarVisible(false);
    }

    private void adjustBorder() {
        if (this.isControlBarVisible()) {
            this.webBrowserPanel.setBorder(BorderFactory.createBevelBorder(1));
        } else {
            this.webBrowserPanel.setBorder(null);
        }
    }

    private Icon createIcon(String resourceKey) {
        String value = this.RESOURCES.getString(resourceKey);
        return value.length() == 0 ? null : new ImageIcon(JWebBrowser.class.getResource(value));
    }

    public void load(Class<?> clazz, String resourcePath) {
        this.load(clazz, resourcePath, null);
    }

    public void load(Class<?> clazz, String resourcePath, FlashPluginOptions options) {
        this.addReferenceClassLoader(clazz.getClassLoader());
        this.load(WebServer.getDefaultWebServer().getClassPathResourceURL(clazz.getName(), resourcePath), options);
    }

    public void load(String resourceLocation) {
        this.load(resourceLocation, null);
    }

    public void load(String resourceLocation, FlashPluginOptions options) {
        if ("".equals(resourceLocation)) {
            resourceLocation = null;
        }
        if (options == null) {
            options = new FlashPluginOptions();
        }
        this.options = options;
        this.webBrowserObject.load(resourceLocation);
        boolean isEnabled = resourceLocation != null;
        this.playButton.setEnabled(isEnabled);
        this.pauseButton.setEnabled(isEnabled);
        this.stopButton.setEnabled(isEnabled);
    }

    public void play() {
        if (!this.webBrowserObject.hasContent()) {
            return;
        }
        this.webBrowserObject.invokeObjectFunction("Play", new Object[0]);
    }

    public void pause() {
        if (!this.webBrowserObject.hasContent()) {
            return;
        }
        this.webBrowserObject.invokeObjectFunction("StopPlay", new Object[0]);
    }

    public void stop() {
        if (!this.webBrowserObject.hasContent()) {
            return;
        }
        this.webBrowserObject.invokeObjectFunction("Rewind", new Object[0]);
    }

    public void setVariable(String name, String value) {
        if (!this.webBrowserObject.hasContent()) {
            return;
        }
        this.webBrowserObject.invokeObjectFunction("SetVariable", name, value);
    }

    public Object getVariable(String name) {
        if (!this.webBrowserObject.hasContent()) {
            return null;
        }
        return this.webBrowserObject.invokeObjectFunctionWithResult("GetVariable", name);
    }

    public void invokeFlashFunction(String functionName, Object ... args) {
        this.webBrowserObject.invokeObjectFunction(functionName, args);
    }

    public Object invokeFlashFunctionWithResult(String functionName, Object ... args) {
        return this.webBrowserObject.invokeObjectFunctionWithResult(functionName, args);
    }

    public JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public boolean isControlBarVisible() {
        return this.controlBarPane.isVisible();
    }

    public void setControlBarVisible(boolean isControlBarVisible) {
        this.controlBarPane.setVisible(isControlBarVisible);
        this.adjustBorder();
    }

    public void addFlashPlayerListener(FlashPlayerListener listener) {
        this.listenerList.add(FlashPlayerListener.class, listener);
    }

    public void removeFlashPlayerListener(FlashPlayerListener listener) {
        this.listenerList.remove(FlashPlayerListener.class, listener);
    }

    public FlashPlayerListener[] getFlashPlayerListeners() {
        return (FlashPlayerListener[])this.listenerList.getListeners(FlashPlayerListener.class);
    }

    private void addReferenceClassLoader(ClassLoader referenceClassLoader) {
        if (referenceClassLoader == null || referenceClassLoader == this.getClass().getClassLoader() || this.referenceClassLoaderList.contains(referenceClassLoader)) {
            return;
        }
        this.referenceClassLoaderList.add(referenceClassLoader);
        WebServer.getDefaultWebServer().addReferenceClassLoader(referenceClassLoader);
    }

    protected void finalize() throws Throwable {
        for (ClassLoader referenceClassLoader : this.referenceClassLoaderList) {
            WebServer.getDefaultWebServer().removeReferenceClassLoader(referenceClassLoader);
        }
        this.referenceClassLoaderList.clear();
        super.finalize();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.cleanup();
    }

    @Override
    public void disposeNativePeer() {
        super.disposeNativePeer();
        this.cleanup();
    }

    private void cleanup() {
        if (this.isNativePeerDisposed()) {
            this.webBrowserObject.load(null);
        }
    }

    private static class NWebBrowserObject
    extends WebBrowserObject {
        private final JFlashPlayer flashPlayer;
        private final String LS = Utils.LINE_SEPARATOR;

        NWebBrowserObject(JFlashPlayer flashPlayer) {
            super(flashPlayer.webBrowser);
            this.flashPlayer = flashPlayer;
        }

        protected WebBrowserObject.ObjectHTMLConfiguration getObjectHtmlConfiguration() {
            WebBrowserObject.ObjectHTMLConfiguration objectHTMLConfiguration = new WebBrowserObject.ObjectHTMLConfiguration();
            if (this.flashPlayer.options != null) {
                String loadedResource;
                Map<String, String> htmlParameters = this.flashPlayer.options.getHTMLParameters();
                if (!htmlParameters.containsKey("base") && (loadedResource = this.flashPlayer.webBrowserObject.getLoadedResource()) != null) {
                    int lastIndex = loadedResource.lastIndexOf(47);
                    htmlParameters.put("base", loadedResource.substring(0, lastIndex + 1));
                }
                objectHTMLConfiguration.setHTMLParameters(htmlParameters);
            }
            objectHTMLConfiguration.setWindowsClassID("D27CDB6E-AE6D-11cf-96B8-444553540000");
            objectHTMLConfiguration.setWindowsInstallationURL("http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,0,0");
            objectHTMLConfiguration.setMimeType("application/x-shockwave-flash");
            objectHTMLConfiguration.setInstallationURL("http://www.adobe.com/go/getflashplayer");
            objectHTMLConfiguration.setWindowsParamName("movie");
            objectHTMLConfiguration.setParamName("src");
            return objectHTMLConfiguration;
        }

        protected String getJavascriptDefinitions() {
            String javascriptDefinitions = this.flashPlayer.customJavascriptDefinitions;
            return "function " + NWebBrowserObject.getEmbeddedObjectJavascriptName() + "_DoFScommand(command, args) {" + this.LS + "  sendCommand(command, args);" + this.LS + "}" + this.LS + (javascriptDefinitions == null ? "" : javascriptDefinitions);
        }

        public String getLocalFileURL(File localFile) {
            return WebServer.getDefaultWebServer().getResourcePathURL(localFile.getParent(), localFile.getName());
        }
    }
}

